﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private InstructorBL _InstructorBL = null;

        public InstructorBL Instructor
        {
            get
            {
                if (_InstructorBL == null)
                {
                    _InstructorBL = new InstructorBL(this);
                }

                return _InstructorBL;
            }
        }

        public class InstructorBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
        {
            public InstructorBL(ZSBELearning BL) : base(BL) { }

            public Gemini.Core.BL.Base.MethodResult Save(BL.BO.Instructor Instructor)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {

                    if (Instructor == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        PI.FM.N001.Account.BL.BO.View.User _checkUser = BLP.RBL.Account.User.View.RestoreByEmail(Instructor.Email);
                        if ((_checkUser != null) && (_checkUser.ID != Instructor.UserID))
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.Email.AlreadyRegistered.Value, false);
                        }
                        else
                        {
                            if (!Gemini.Core.BL.Utility.Validate.IsValidEmail(Instructor.Email))
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.Email.NotValid.Value, false);
                            }
                        }

                        if (_methodResult.Success)
                        {

                            if (Instructor.ID.HasValue)
                            {
                                #region Update
                                _methodResult.SetSuccess = BLP.DAL.Instructor.Update(Instructor);

                                if (_methodResult.Success)
                                {
                                    PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.RestoreByID(Instructor.UserID);
                                    if (_user != null)
                                    {
                                        _user.Login = Instructor.Email;
                                        _user.Name = Instructor.Forename;
                                        _user.Surname = Instructor.Surename;

                                        if (!String.IsNullOrEmpty(Instructor.TmpPassword))
                                        {
                                            _user.Password = Instructor.TmpPassword;
                                        }
                                        _methodResult.Add(BLP.RBL.Account.User.Save(_user));

                                        if (_methodResult.Success)
                                        {
                                            Instructor.TmpPassword = _user.Password;
                                            BLP.APIEduFarma.SyncInstructorSave(Instructor);
                                        }
                                    }
                                }
                                #endregion
                            }
                            else
                            {
                                #region Create

                                PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.New();
                                _user.Flags = PI.FM.N001.Account.BL.BO.User.FlagsType.None;
                                _user.GroupID = BLP.RBL.Account.Group.Restore(BLP.ClientID, (int)Dictionary.GroupType.Instructor).ID;
                                _user.Email = Instructor.Email;
                                _user.Name = Instructor.Forename;
                                _user.Surname = Instructor.Surename;
                                _user.Password = Gemini.Utility.Text.GetRandomString(BLP.RBL.VariableRepository.GetInt(PI.FM.N001.Account.BL.Dictionary.Options.PasswordMinLength, BLP.RBL.Account.ClientID, Gemini.Dictionary.GlobalParams.MPasswordLength));                               
                                _user.ClientID = BLP.ClientID;

#warning Wymienic na dedykowana metoda wysylania emaila;
                                if (BLP.RBL.Account.User.BLP.User.EmailPassword(_user).Success)
                                {
                                    _methodResult.Add(BLP.RBL.Account.User.Save(_user));

                                    if (_methodResult.Success)
                                    {
                                        Instructor.UserID = _user.ID;
                                        Instructor.TmpPassword = _user.Password;

                                        _methodResult.SetSuccess = BLP.DAL.Instructor.Create(Instructor);

                                        if (_methodResult.Success)
                                        {
                                            BLP.APIEduFarma.SyncInstructorAdd(Instructor);
                                        }
                                    }
                                }
                                else
                                {
                                    _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Instructor.CreateFailedCauseEmail.Value, Instructor.Email), false);
                                }
                                #endregion
                            }
                        }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Instructor.SaveFailed.Value, Instructor.DisplayValue, _exception));
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.Instructor.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public int Count()
            {
                return BLP.DAL.Instructor.Count();
            }

            public List<BL.BO.Instructor> Restore()
            {
                return BLP.DAL.Instructor.Restore();
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BL.BO.Instructor Instructor)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Instructor != null && Instructor.ID.HasValue)
                {
                    try
                    {
                        if (BLP.Class.Count(Instructor) > 0)
                        {
                            _methodResult.Add(Dictionary.Text.Instructor.RemoveFailes_ExistsClass.Value, false);
                        }
                        else
                        {
                            _methodResult.SetSuccess = BLP.DAL.Instructor.Remove(Instructor);

                            if (_methodResult.Success)
                            {
                                BLP.APIEduFarma.SyncInstructorDelete(Instructor);
                                if (Instructor.UserID != null)
                                {
                                    PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.RestoreByID(Instructor.UserID);
                                    if (_user != null)
                                    {
                                        _methodResult.Add(BLP.RBL.Account.User.Remove(_user, BLP.ClientID));
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception _exception)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                    }
                }

                return _methodResult;
            }

            public BL.BO.Instructor New()
            {
                return BLP.DAL.Instructor.New();
            }

            public BL.BO.Instructor Restore(long? ID)
            {
                return BLP.DAL.Instructor.Restore(ID);
            }

            public BO.Instructor Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.Instructor _Instructor = null;

                if ((BO != null) && (BO.ID.HasValue))
                {
                    _Instructor = Restore(BO.ID);
                }

                return _Instructor;
            }

            public List<BL.BO.Instructor> Restore(BL.BO.Instructor.Search Search)
            {
                return BLP.DAL.Instructor.Restore(Search);
            }

            public List<BL.BO.Instructor> Restore(BL.BO.School School)
            {
                List<BL.BO.Instructor> _instructorList = new List<BO.Instructor>();

                if (School != null && School.ID.HasValue)
                {
                    BL.BO.Instructor.Search _search = new BO.Instructor.Search();
                    _search.SchoolID = School.ID;

                    _instructorList = BLP.DAL.Instructor.Restore(_search);
                }

                return _instructorList;
            }

            public BL.BO.Instructor RestoreByUser(Gemini.Core.BL.Interface.BO.IUser User)
            {
                BL.BO.Instructor _instructor = null;

                if (User != null && User.ID.HasValue)
                {
                    BL.BO.Instructor.Search _search = new BO.Instructor.Search();
                    _search.UserID = User.ID;

                    _instructor = BLP.DAL.Instructor.RestoreTopOne(_search);
                }

                return _instructor;
            }

            public BL.BO.Instructor Restore(BL.BO.Class Class)
            {
                BL.BO.Instructor _instructor = null;

                if (Class != null && Class.InstructorID.HasValue)
                {
                    _instructor = BLP.DAL.Instructor.Restore(Class.InstructorID);
                }

                return _instructor;
            }

            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.Instructor> Restore(BO.Instructor.Search Search)
                {
                    return BLP.DAL.InstructorView.Restore(Search);
                }

                public BO.View.Instructor Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
                {
                    return BLP.DAL.InstructorView.Restore(BO.ID);
                }
            }

            Gemini.Core.BL.Interface.BO.IBaseUnique<long?> Gemini.Core.BL.Interface.IBORestoreByID.RestoreByID(long? ID)
            {
                return Restore(ID);
            }
        }
    }
}
